/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world.cap.events;

import dev.toma.gunsrpg.api.common.data.IWorldEventHandler;
import dev.toma.gunsrpg.api.common.data.IWorldEventSpec;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class WorldEventSpec
implements IWorldEventSpec {
    public static final Marker MARKER = MarkerManager.getMarker((String)"WorldEvent");
    private final String name;
    private final Supplier<Integer> cycle;
    private final IWorldEventHandler handler;
    private boolean active;
    private boolean old;

    public WorldEventSpec(String name, Supplier<Integer> cycle, IWorldEventHandler handler) {
        this.name = name;
        this.cycle = cycle;
        this.handler = handler;
    }

    @Override
    public void tick(World world, long currentDay) {
        if (this.disabled()) {
            return;
        }
        int dayCycle = this.cycle.get();
        boolean bl = this.active = currentDay > 0L && (dayCycle == 0 || currentDay % (long)dayCycle == 0L) && this.handler.canTriggerEvent(world);
        if (this.active != this.old) {
            if (this.active) {
                this.handler.eventStarted(world);
            } else {
                this.handler.eventFinished(world);
            }
        }
        this.old = this.active;
    }

    @Override
    public boolean isEventActive() {
        return this.active;
    }

    @Override
    public String getEventName() {
        return this.name;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("now", this.active);
        nbt.func_74757_a("old", this.old);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.active = nbt.func_74767_n("now");
        this.old = nbt.func_74767_n("old");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldEventSpec that = (WorldEventSpec)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean disabled() {
        return this.cycle.get() < 0;
    }
}

